#include <stm32f10x.h>		 
#include "sys.h"
//////////////////////////////////////////////////////////////////////////////////	 
//V1.4޸˵
//NVIC KO,ûʹκοļ!
//JTAG_Set
////////////////////////////////////////////////////////////////////////////////// 	  

//˵:ʮתַ	(8bit)
//hex_strҪתʮ
//      char_str:תŵַ
//      tran_num:תĸ
//ֵ
void Hex_Tran_Char_8bit(u8* hex_str,u8* char_str,u8 tran_num)
{
   	u8 i,model[16]={'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
	for(i=0;i<tran_num;i++)
	{
	   	char_str[2*i]=model[(hex_str[i]>>4)&0x0F];
		char_str[2*i+1]=model[hex_str[i]&0x0F];
	}
	char_str[2*i]=0;//ַ

}


//˵:ʮתַ(16bit)
//hex_strҪתʮ
//      char_str:תŵַ
//      tran_num:תĸ
//ֵ
void Hex_Tran_Char_16bit(u16* hex_str,u8* char_str,u8 tran_num)
{
   	u8 i,model[16]={'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
	for(i=0;i<tran_num;i++)
	{
	   	char_str[4*i]=model[(hex_str[i]>>12)&0x0F];
		char_str[4*i+1]=model[(hex_str[i]>>8)&0x0F];
		char_str[4*i+2]=model[(hex_str[i]>>4)&0x0F];
		char_str[4*i+3]=model[hex_str[i]&0x0F];

	}
	char_str[4*i]=0;//ַ

}

//˵ƫƵַ
//NVIC_VectTab - ַ
//      Offset - ƫ
//ֵ
void MY_NVIC_SetVectorTable(u32 NVIC_VectTab, u32 Offset)	 
{ 
  	//Ϸ
	assert_param(IS_NVIC_VECTTAB(NVIC_VectTab));
	assert_param(IS_NVIC_OFFSET(Offset));  	 
	SCB->VTOR = NVIC_VectTab|(Offset & (u32)0x1FFFFF80);//NVICƫƼĴ
	//ڱʶCODERAM
}

//˵NVIC
//NVIC_Group - NVIC 0~4 ܹ5 
//ֵ
void MY_NVIC_PriorityGroupConfig(u8 NVIC_Group)	 
{ 
	u32 temp,temp1;	  
	temp1=(~NVIC_Group)&0x07;//ȡλ
	temp1<<=8;
	temp=SCB->AIRCR;  //ȡǰ
	temp&=0X0000F8FF; //ǰ
	temp|=0X05FA0000; //дԿ
	temp|=temp1;	   
	SCB->AIRCR=temp;  //÷	    	  				   
}

//˵NVIC 
//NVIC_PreemptionPriority - ռȼ
//      NVIC_SubPriority        - Ӧȼ
//		NVIC_Channel            - жϱ
//		NVIC_Group              - жϷ 0~4
// 		עȼܳ趨ķΧ!
//		黮:
//		0:0λռȼ,4λӦȼ
//		1:1λռȼ,3λӦȼ
//		2:2λռȼ,2λӦȼ
//		3:3λռȼ,1λӦȼ
//		4:4λռȼ,0λӦȼ
//		NVIC_SubPriorityNVIC_PreemptionPriorityԭ,ֵԽС,Խ
//ֵ

//˵ⲿжú
//          ֻGPIOA~G;PVD,RTCUSB
//:GPIOx:0~6,GPIOA~G;
//     BITx:Ҫʹܵλ;
//     TRIM:ģʽ,1,½;2,;3ƽ
//     úһֻ1IO,IO,ε
//     úԶӦж,Լ   
//ֵ
void Ex_NVIC_Config(u8 GPIOx,u8 BITx,u8 TRIM) 
{
	u8 EXTADDR;
	u8 EXTOFFSET;
	EXTADDR=BITx/4;//õжϼĴı
	EXTOFFSET=(BITx%4)*4;

	RCC->APB2ENR|=0x01;//ʹioʱ

	AFIO->EXTICR[EXTADDR]&=~(0x000F<<EXTOFFSET);//ԭã
	AFIO->EXTICR[EXTADDR]|=GPIOx<<EXTOFFSET;//EXTI.BITxӳ䵽GPIOx.BITx
	
	//Զ
	EXTI->IMR|=1<<BITx;//  line BITxϵж
	//EXTI->EMR|=1<<BITx;//line BITxϵ¼ (,ӲǿԵ,ʱ޷ж!)
 	if(TRIM&0x01)EXTI->FTSR|=1<<BITx;//line BITx¼½ش
	if(TRIM&0x02)EXTI->RTSR|=1<<BITx;//line BITx¼ش
} 


//˵ʱӼĴλ		    
//
//ֵ
void MYRCC_DeInit(void)
{										  					   
	RCC->APB1RSTR = 0x00000000;//λ			 
	RCC->APB2RSTR = 0x00000000; 
	  
  	RCC->AHBENR = 0x00000014;  //˯ģʽSRAMʱʹ.ر.	  
  	RCC->APB2ENR = 0x00000000; //ʱӹر.			   
  	RCC->APB1ENR = 0x00000000;   
	RCC->CR |= 0x00000001;     //ʹڲʱHSION	 															 
	RCC->CFGR &= 0xF8FF0000;   //λSW[1:0],HPRE[3:0],PPRE1[2:0],PPRE2[2:0],ADCPRE[1:0],MCO[2:0]					 
	RCC->CR &= 0xFEF6FFFF;     //λHSEON,CSSON,PLLON
	RCC->CR &= 0xFFFBFFFF;     //λHSEBYP	   	  
	RCC->CFGR &= 0xFF80FFFF;   //λPLLSRC, PLLXTPRE, PLLMUL[3:0] and USBPRE 
	RCC->CIR = 0x00000000;     //رж
	//				  
#ifdef  VECT_TAB_RAM
	MY_NVIC_SetVectorTable(NVIC_VectTab_RAM, 0x0);
#else   
	MY_NVIC_SetVectorTable(NVIC_VectTab_FLASH, 0x0);
#endif
}


//˵ģʽ	 
// 
//ֵ
void Sys_Standby(void)
{
	SCB->SCR|=1<<2;//ʹSLEEPDEEPλ (SYS->CTRL)	   
  	RCC->APB1ENR|=1<<28;     //ʹܵԴʱ	    
 	PWR->CSR|=1<<8;          //WKUPڻ
	PWR->CR|=1<<2;           //Wake-up ־
	PWR->CR|=1<<1;           //PDDSλ		 	 
}
	  
//󱸼Ĵд
//reg:Ĵ
//reg:Ҫдֵ 
////check ok
////091202
//void BKP_Write(u8 reg,u16 dat)
//{
//  RCC->APB1ENR|=1<<28;     //ʹܵԴʱ	    
//	RCC->APB1ENR|=1<<27;     //ʹܱʱ	    
//	PWR->CR|=1<<8;           //ȡд 
//	switch(reg)
//	{
//		case 1:
//			BKP->DR1=dat;
//			break;
//		case 2:
//			BKP->DR2=dat;
//			break;
//		case 3:
//			BKP->DR3=dat;
//			break; 
//		case 4:
//			BKP->DR4=dat;
//			break;
//		case 5:
//			BKP->DR5=dat;
//			break;
//		case 6:
//			BKP->DR6=dat;
//			break;
//		case 7:
//			BKP->DR7=dat;
//			break;
//		case 8:
//			BKP->DR8=dat;
//			break;
//		case 9:
//			BKP->DR9=dat;
//			break;
//		case 10:
//			BKP->DR10=dat;
//			break;
//	} 
//}	  
  
//˵ϵͳλ
//
//ֵ
void Sys_Soft_Reset(void)
{   
	SCB->AIRCR =0X05FA0000|(u32)0x04;	  
} 

//˵JTAGģʽ,JTAGģʽ
//mode - jtag,swdģʽ;00,ȫʹ;01,ʹSWD;10,ȫر;
//ֵ		  
void JTAG_Set(u8 mode)
{
	u32 temp;
	temp=mode;
	temp<<=25;
	RCC->APB2ENR|=1<<0;     //ʱ	   
	AFIO->MAPR&=0XF8FFFFFF; //MAPR[26:24]
	AFIO->MAPR|=temp;       //jtagģʽ
} 

//˵ϵͳʱӳʼ
// pll - ѡıƵ2ʼֵΪ16	
//ֵ
void Stm32_Clock_Init(u8 PLL)
{
	unsigned char temp=0;   
	MYRCC_DeInit();		  //λ
	RCC->CR|=0x00010000;  //ⲿʱʹHSEON Ĭʹڲ񣬹رⲿ
	while(!(RCC->CR>>17));//ȴⲿʱӾ
	RCC->CFGR=0X00000400; //APB1=DIV2;APB2=DIV1;AHB=DIV1;
	PLL-=2;//2λ
	RCC->CFGR|=PLL<<18;   //PLLֵ 2~16
	RCC->CFGR|=1<<16;	  //PLLSRC ON 
	FLASH->ACR|=0x32;	  //FLASH 2ʱ

	RCC->CR|=0x01000000;  //PLLON
	while(!(RCC->CR>>25));//ȴPLL
	RCC->CFGR|=0x00000002;//PLLΪϵͳʱ	 
	while(temp!=0x02)     //ȴPLLΪϵͳʱóɹ
	{   
		temp=RCC->CFGR>>2;
		temp&=0x03;
	}    
}		    
